//adapted from Original GLSLSandbox fragment shader
// // https://glslsandbox.com/e#78115.0
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels
#define time u_Elapsed* 0.3141592
#define resolution u_WindowSize
#define mouse vec4(0.0,0.0, 0.0,0.0)
#ifdef GL_ES
precision highp float;
#endif

uniform sampler2D iChannel0;
#extension GL_OES_standard_derivatives : enable

vec3 lightDir = vec3(0.4, 0.5, -0.4);

vec3 trans(vec3 p, float d){
	return mod(p, d) - d/2.;
}

float dfSphere(vec3 p, float r){
	return length(p) - r;
}

float dfFloor(vec3 p, vec3 n){
	return dot(p, n) + 5.;
}

float map(vec3 p){
	float d2 = dfFloor(p, vec3(0., 1., 0.));
	p = trans(p, 8.);
	float d1 = dfSphere(p, 1.);
	// return d1;
	return min(d1, d2);
}

vec3 getNormal(vec3 p){
	float d = 0.001;
	return normalize(vec3(
		map(p + vec3(d, 0., 0.)) - map(p - vec3(d, 0., 0.)),
		map(p + vec3(0., d, 0.)) - map(p - vec3(0., d, 0.)),
		map(p + vec3(0., 0., d)) - map(p - vec3(0., 0. ,d))
		));
}

float genShadow(vec3 ro, vec3 rd){
	float h = 0.0;
	float c = 0.001;
	float r = 1.0;
	float shadowCoef=0.5;
	for(int i=0;i<40;i++){
		h = map(ro+c*rd);
		if(h<0.001){
			return shadowCoef;
		}
		r = min(r, h * 16.0 / c);
		c+=h;
	}
	return mix(shadowCoef, 1.0, r);
}

void main( void ) {

	vec2 p = ( gl_FragCoord.xy  * 2. - resolution.xy ) / min(resolution.x, resolution.y);

	vec3 color = vec3(0.0);
	
	vec3 cPos = vec3(0., 0., -4. - time);
	vec3 cT = vec3(0., 0., -time);
	vec3 cFwd = normalize(cT - cPos);
	 //vec3 rd = normalize(vec3(p,1. + (1. - dot(p, p)) * 0.6));
	vec3 rd = normalize(vec3(p.x, p.y, 0.) + ((1. - dot(p, p)) * .3 + 1.) * cFwd);
	
	
	float d, tmp;
	vec3 dPos = cPos;
	int k;
	float ac = 0.0;
	
	for(int i=0;i<30;i++){
		d = map(dPos);
		if(d<0.001){
			k = i;
		//	break;
		}
		d = max(abs(d), 0.02);
		ac += exp(-d * 3.);
		
		tmp+=d;
		dPos=cPos+tmp*rd;
	}
	
	float shadow = 1.0;
	vec3 normal;
	
	if(d<0.001){
		normal = getNormal(dPos);
		
		float ao=float(k)/300.;
		float diff = clamp(dot(normal,lightDir), 0.1, 1.0);
		
		shadow = genShadow(dPos + normal * 0.001, lightDir);
		//color += diff + ao;
	}else{
		//color = vec3(0.1, 0.5, 0.3);
	}
	color += ac * 0.03;

	gl_FragColor = vec4(color, 1.0 );

}